/*
 * 
 */
package w83a.w83aDAO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import w83a.util.jdbc.W83aDataBase;
import w83a.w83aBeans.W83aActasBean;
import w83a.w83aBeans.W83aDocBean;
import w83a.w83aBeans.W83aImpugnacionesBean;
import w83a.w83aBeans.W83aIncidenciaActaBean;
import w83a.w83aBeans.W83aListaDelegadosBean;
import w83a.w83aBeans.W83aListaDiferenciasBean;
import w83a.w83aBeans.W83aListaEscrutiniosBean;
import w83a.w83aBeans.W83aPapeletasBean;
import w83a.w83aDAO.w83aConstantesBD.W83aActasBD;
import w83a.w83aDAO.w83aConstantesBD.W83aCentroTrabajoBD;
import w83a.w83aDAO.w83aConstantesBD.W83aColegiosBD;
import w83a.w83aDAO.w83aConstantesBD.W83aConveniosBD;
import w83a.w83aDAO.w83aConstantesBD.W83aDelegadosBD;
import w83a.w83aDAO.w83aConstantesBD.W83aDiferenciasBD;
import w83a.w83aDAO.w83aConstantesBD.W83aEscrutiniosBD;
import w83a.w83aDAO.w83aConstantesBD.W83aImpugnacionesBD;
import w83a.w83aDAO.w83aConstantesBD.W83aMotivosBajaActaBD;
import w83a.w83aDAO.w83aConstantesBD.W83aMotivosBajaDelegadoBD;
import w83a.w83aDAO.w83aConstantesBD.W83aMunicipioBD;
import w83a.w83aDAO.w83aConstantesBD.W83aPapeletasBD;
import w83a.w83aDAO.w83aConstantesBD.W83aProvinciasBD;
import w83a.w83aDAO.w83aConstantesBD.W83aSindicatosBD;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aDateUtil;


// TODO: Auto-generated Javadoc
/**
 * The Interface W83bIPreavisosDAO.
 * @author a
 */
public class W83aActaDAO implements W83aIActaDAO{
	
	public W83aActasBean detalleActas(w83a.w83aBeans.W83aActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aActasBD.versionActa).append(",");
		strSql.append(W83aActasBD.numActa).append(",");
		strSql.append(W83aActasBD.anyoActa).append(",");
		strSql.append(W83aActasBD.codTerritActa).append(",");
		strSql.append(W83aActasBD.numPreaviso).append(",");
		strSql.append(W83aActasBD.anyoPreaviso).append(",");
		strSql.append(W83aActasBD.codConvenio).append(",");
		if (param.getIdioma().equals(W83aClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83aConveniosBD.descripcion).append(" AS DESC_CONVENIO,");
			strSql.append(W83aMotivosBajaActaBD.descMotivoCast).append(" AS DESC_BAJA,");
		}
		else{
			strSql.append(W83aConveniosBD.descripcion_eusk).append(" AS DESC_CONVENIO,");
			strSql.append(W83aMotivosBajaActaBD.descMotivoEusk).append(" AS DESC_BAJA,");
		}
		strSql.append(W83aActasBD.codCentro).append(",");
		strSql.append(W83aActasBD.codMotivosBaja).append(",TO_CHAR (");
		strSql.append(W83aActasBD.fechaEntrada).append(",?) F_ENTRA_016 ,TO_CHAR (");
		strSql.append(W83aActasBD.fechaEleccion).append(",?) F_ELECC_016,TO_CHAR (");
		strSql.append(W83aActasBD.fechaRegistro).append(",?) FREGLIB_016,TO_CHAR (");
		strSql.append(W83aActasBD.fecRegDefinitivo).append(",?) FREGDEF_016,TO_CHAR (");
		strSql.append(W83aActasBD.fechaComision).append(",?) F_COMIS_016,TO_CHAR (");
		strSql.append(W83aActasBD.fechaRequerimiento).append(",?) F_REQUE_016,TO_CHAR (");
		strSql.append(W83aActasBD.fechaSubsanacionReq).append(",?) F_SUBREQ_016,TO_CHAR (");
		strSql.append(W83aActasBD.fechaRetiradaComision).append(",?) F_RETCOM_016,TO_CHAR (");
		strSql.append(W83aActasBD.fechaPresentacionRegRegInterno).append(",?) F_PRRI_016,TO_CHAR (");
		strSql.append(W83aActasBD.fechaBaja).append(",?) F_BAJA_016,TO_CHAR (");
		strSql.append(W83aActasBD.fechaActualizacion).append(",?) FACTU_016,");
		
		strSql.append(W83aActasBD.totalElectores).append(",");
		strSql.append("(").append(W83aActasBD.nCandidatosHombre).append("+");
		strSql.append(W83aActasBD.nCandidatosMujer).append(") AS ").append(W83aActasBD.totalCandidatos).append(",");
		strSql.append(W83aActasBD.nCandidatosHombre).append(",");
		strSql.append(W83aActasBD.nCandidatosMujer).append(",");
		strSql.append(W83aActasBD.anyoTotalActa).append(",");
		strSql.append(W83aActasBD.numTotalActa).append(",");
		strSql.append(W83aActasBD.numRegistro).append(",");
		strSql.append(W83aActasBD.anyoRegDefinitivo).append(",");
		strSql.append(W83aActasBD.numRegDefinitivo).append(",");
		strSql.append(W83aActasBD.nElectoresHombre).append(",");
		strSql.append(W83aActasBD.nElectoresMujer).append(",");
		strSql.append(W83aActasBD.marcaComision).append(",");
		strSql.append(W83aActasBD.observaciones).append(",");
		strSql.append(W83aActasBD.usuarioActualizacion).append(",");
		strSql.append(W83aActasBD.inspeccionada).append(",");
		strSql.append(W83aActasBD.F_CONSTCOM_016).append(",");
		strSql.append(W83aActasBD.REMITE_016).append(",");
		strSql.append(W83aActasBD.validada).append(",");
		strSql.append(W83aCentroTrabajoBD.codNifCif).append(",");
		strSql.append(W83aCentroTrabajoBD.ncentroTrab).append(",");
		strSql.append(W83aCentroTrabajoBD.codPostalCentro).append(",");
		strSql.append(W83aCentroTrabajoBD.domicilioCentro).append(",");
		strSql.append(" PROVINCIA ,MUNICIPIO,");
		strSql.append(W83aCentroTrabajoBD.codProvinciaCentro).append(",");
		strSql.append(W83aCentroTrabajoBD.razonSocial).append(",");
		strSql.append(W83aCentroTrabajoBD.localidadCentro).append(",");
		strSql.append(W83aActasBD.maxDel).append(",");
		strSql.append(" DELEGADOS, TOTALESCR,TOTALDIF,DELEGADOSH,DELEGADOSM,ESCRHOMBRES0,ESCRHOMBRES1").append(",");
		strSql.append(" ESCRMUJERES0,ESCRMUJERES1,DIFHOMBRES0,DIFHOMBRES1,DIFMUJERES0,DIFMUJERES1, ");
		strSql.append(" MUN_001,PROVC_001 ");
		
	    strSql.append(" FROM TABLE (w83b.DETALLEACTADATOSC");
	    params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	    strSql.append("(?,?,?,?))");
	    
	    params.add(param.getNumActa());//
	    params.add(param.getNumActaAno());
	    params.add(param.getNumActaTerritorio());
	    params.add(param.getVersion());
	    
		List listaActas = W83aDataBase.executeQuery(strSql.toString(),params,W83aActasBean.class,param.getUsuarioBean(), "DETALLE");
		
		return (W83aActasBean)listaActas.get(0);		
		
	}
	public java.util.List buscarPapeletas(w83a.w83aBeans.W83aActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83aPapeletasBD.blancas).append(",");
		strSql.append(W83aPapeletasBD.validas).append(",");
		strSql.append(W83aPapeletasBD.nulas).append(",");
		strSql.append(W83aPapeletasBD.codColegio).append(",");
		strSql.append(W83aPapeletasBD.electores).append(",");
		strSql.append(W83aPapeletasBD.votantes);
		strSql.append(" FROM ").append(W83aPapeletasBD.papeletasVista);
		strSql.append(" WHERE ").append(W83aPapeletasBD.acta).append(" = ? ");
		strSql.append(" AND ").append(W83aPapeletasBD.anyoActa).append(" = ? ");
		strSql.append(" AND ").append(W83aPapeletasBD.territorioActa).append(" = ? ");
		strSql.append(" AND ").append(W83aPapeletasBD.versionActa).append(" = ? ");
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersion());
		return W83aDataBase.executeQuery(strSql.toString(),params,W83aPapeletasBean.class,param.getUsuarioBean(), null);
		
	}
	public java.util.List cargarColegios() throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aColegiosBD.cod);
		strSql.append(" ,");
		strSql.append(W83aColegiosBD.descripcion);
		strSql.append(" ,");
		strSql.append(W83aColegiosBD.descripcion_eu);
		strSql.append(" FROM ");
		strSql.append(W83aColegiosBD.colegiosTable);
		strSql.append(" ORDER BY ");
		strSql.append(W83aColegiosBD.cod);
		List listaDatosParametros = W83aDataBase.executeQuery(strSql.toString(),params,null);
		
		return listaDatosParametros;
	}
	public List buscarDelegadosActa(w83a.w83aBeans.W83aActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		//IDENTIFICAR USUARIO
		//W83aDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
		
		List params = new ArrayList();
		strSql.append("SELECT COUNT(").append(W83aDelegadosBD.dni).append(") AS DELEGADOS,");
		strSql.append(W83aDelegadosBD.dni).append(",").append(W83aDelegadosBD.sexo).append(",").append(W83aDelegadosBD.codSindicato).append(",");
		strSql.append(W83aDelegadosBD.codColegio).append(",").append(W83aDelegadosBD.apellido1).append(",").append(W83aDelegadosBD.apellido2).append(",");
		strSql.append(W83aDelegadosBD.nombre).append(",").append(W83aDelegadosBD.dniSustituto).append(", TO_CHAR(");
		strSql.append(W83aDelegadosBD.fechaAlta).append(",?) ").append(W83aDelegadosBD.fechaAlta).append(", TO_CHAR(");
		strSql.append(W83aDelegadosBD.fechaMod).append(",?) ").append(W83aDelegadosBD.fechaMod).append(", TO_CHAR(");
		strSql.append(W83aDelegadosBD.fechaBaja).append(",?) ").append(W83aDelegadosBD.fechaBaja).append(",");
		strSql.append(W83aDelegadosBD.baja).append(",");
		strSql.append("CASE WHEN ").append(W83aDelegadosBD.codColegio).append("=0 THEN '").append(W83aClsConstantes.CONSTANTE_DESCRIP_TECNICOS).append("' ELSE '").append(W83aClsConstantes.CONSTANTE_DESCRIP_ESPECIALISTAS).append("' END AS COLEGIO").append(",");
		strSql.append(W83aSindicatosBD.siglas).append(" SINDICATO,");
		if (param.getIdioma().equals(W83aClsConstantes.CONSTANTE_CASTELLANO)){
			
			//.append(W83aColegiosBD.descripcion).append(" COLEGIO,");
			strSql.append(W83aColegiosBD.descripcion).append(" AS DESCCOLEGIO,");
			strSql.append(W83aMotivosBajaDelegadoBD.descMotivoCast).append(" BAJA");
		}
		else{

			//.append(W83aColegiosBD.descripcion_eu).append(" COLEGIO,");
			strSql.append(W83aColegiosBD.descripcion_eu).append(" AS DESCCOLEGIO,");
			strSql.append(W83aMotivosBajaDelegadoBD.descMotivoEusk).append(" BAJA");
		}
		
		strSql.append(" FROM ").append(W83aDelegadosBD.delegadosVista).append(",").append(W83aSindicatosBD.sindicatosVista).append(",");
		strSql.append(W83aColegiosBD.colegiosTable).append(",").append(W83aMotivosBajaDelegadoBD.motivosBajaVista);
		strSql.append(" WHERE ").append(W83aDelegadosBD.acta).append("=? AND ").append(W83aDelegadosBD.anyoActa).append("=? AND ");
		strSql.append(W83aDelegadosBD.territorioActa).append("=? AND ").append(W83aDelegadosBD.versionActa).append("=? AND ");
		strSql.append(W83aDelegadosBD.codSindicato).append("=").append(W83aSindicatosBD.codSindicato).append(" AND ");
		strSql.append(W83aDelegadosBD.codColegio).append("=").append(W83aColegiosBD.cod).append(" AND ");
		strSql.append(W83aDelegadosBD.baja).append("=").append(W83aMotivosBajaDelegadoBD.codMotivo).append("(+)");
		strSql.append(" GROUP BY ").append(W83aDelegadosBD.codSindicato).append(", ").append(W83aDelegadosBD.codColegio).append(", ");
		strSql.append(W83aDelegadosBD.sexo).append(", ").append(W83aDelegadosBD.dni).append(", ");
		strSql.append(W83aDelegadosBD.codColegio).append(",").append(W83aDelegadosBD.apellido1).append(",").append(W83aDelegadosBD.apellido2).append(",");
		strSql.append(W83aDelegadosBD.nombre).append(",").append(W83aDelegadosBD.dniSustituto).append(", ");
		strSql.append(W83aDelegadosBD.fechaAlta).append(", ").append(W83aDelegadosBD.fechaBaja).append(",");
		strSql.append(W83aDelegadosBD.fechaMod).append(",");
		strSql.append(W83aDelegadosBD.baja).append(",");
		strSql.append(W83aSindicatosBD.siglas).append(",");
		if (param.getIdioma().equals(W83aClsConstantes.CONSTANTE_CASTELLANO)){
			//strSql.append(W83aSindicatosBD.descSindicatoCast).append(",").append(W83aColegiosBD.descripcion).append(",");
			strSql.append(W83aColegiosBD.descripcion).append(",");
			strSql.append(W83aMotivosBajaDelegadoBD.descMotivoCast);
		}
		else{
			//strSql.append(W83aSindicatosBD.descSindicatoEusk).append(",").append(W83aColegiosBD.descripcion_eu).append(",");
			strSql.append(W83aColegiosBD.descripcion_eu).append(",");
			strSql.append(W83aMotivosBajaDelegadoBD.descMotivoEusk);
		}
		strSql.append(" ORDER BY ");
		strSql.append(" COLEGIO desc,");
		strSql.append(W83aDelegadosBD.dni).append(" asc");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersion());
		List listaActas = W83aDataBase.executeQuery(strSql.toString(),params,W83aListaDelegadosBean.class,param.getUsuarioBean(), "DETALLE");
		//TERMINAR USUARIO
		//W83aDataBase.terminarUsuarioAuditor();
		return listaActas;	
	}
	public java.util.HashMap buscarEscrutinioColegios(w83a.w83aBeans.W83aActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ").append(W83aEscrutiniosBD.codSind).append(",");
		strSql.append(W83aEscrutiniosBD.codigoColegio).append(",").append(W83aEscrutiniosBD.delegadosHombres).append(",");
		strSql.append(W83aEscrutiniosBD.delegadosMujeres).append(",").append(W83aEscrutiniosBD.numVotos).append(",");
		if (param.getIdioma().equals(W83aClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83aSindicatosBD.descSindicatoCast).append(" as DESCRIPCION");
		}
		else{
			strSql.append(W83aSindicatosBD.descSindicatoEusk).append(" as DESCRIPCION");
		}
		strSql.append(" FROM ").append(W83aEscrutiniosBD.escrutVista).append(" ESCR, ").append(W83aSindicatosBD.sindicatosVista).append(" SIND ");
		strSql.append(" WHERE ESCR.").append(W83aEscrutiniosBD.codSind).append(" = ").append(W83aSindicatosBD.codSindicato);
		strSql.append(" AND ESCR.").append(W83aEscrutiniosBD.acta).append(" = ? AND ");
		strSql.append(" ESCR.").append(W83aEscrutiniosBD.anyoActa).append(" = ? AND ");
		strSql.append(" ESCR.").append(W83aEscrutiniosBD.territorioActa).append(" = ? AND ");
		strSql.append(" ESCR.").append(W83aEscrutiniosBD.versionActa).append(" = ? ");
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersion());
		HashMap listaEscrutinios=W83aDataBase.executeQueryHashMap(strSql.toString(),params, W83aListaEscrutiniosBean.class, param.getUsuarioBean(), "DETALLE","sindicatoColegio");
		
		return listaEscrutinios;	
	}
	public java.util.HashMap buscarDiferenciaColegios(w83a.w83aBeans.W83aActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83aDiferenciasBD.codSind).append(",");
		strSql.append(W83aDiferenciasBD.codigoColegio).append(",");
		strSql.append(W83aDiferenciasBD.delegadosHombres).append(",");
		strSql.append(W83aDiferenciasBD.delegadosMujeres).append(",");
		if(param.getIdioma().equals(W83aClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83aSindicatosBD.descSindicatoCast).append(" AS DESCRIPCION");
		}
		else{
			strSql.append(W83aSindicatosBD.descSindicatoEusk).append(" AS DESCRIPCION");
		}
		strSql.append(" FROM ").append(W83aDiferenciasBD.difVista).append(" DIF, ");
		strSql.append(W83aSindicatosBD.sindicatosVista).append(" SIND ");
		strSql.append(" WHERE DIF.").append(W83aDiferenciasBD.codSind).append(" = ");
		strSql.append(W83aSindicatosBD.codSindicato);
		strSql.append(" AND DIF.").append(W83aDiferenciasBD.acta).append(" = ? AND ");
		strSql.append(" DIF.").append(W83aDiferenciasBD.anyoActa).append(" = ? AND ");
		strSql.append(" DIF.").append(W83aDiferenciasBD.territorioActa).append(" = ? AND ");
		strSql.append(" DIF.").append(W83aDiferenciasBD.versionActa).append(" = ? ");
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersion());
		return W83aDataBase.executeQueryHashMap(strSql.toString(),params,W83aListaDiferenciasBean.class,param.getUsuarioBean(), "DETALLE","sindicatoColegio");
		
	}
	public List obtenerDocsActas(w83a.w83aBeans.W83aActasBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aActasBD.doc_id).append(", ");
		strSql.append(W83aActasBD.doc_nombre).append(", ");
		strSql.append(W83aActasBD.doc_territActa).append(", ");
		strSql.append(W83aActasBD.doc_anyoActa).append(", ");
		strSql.append(W83aActasBD.doc_numActa).append(", ");
		strSql.append(W83aActasBD.doc_tipo).append(", ");
		if (param.getIdioma().equals(W83aClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83aActasBD.tip_descCast).append(" DESCRIPCION, ");
			strSql.append(W83aActasBD.doc_descCastFase).append(" FASE, ");
			strSql.append(W83aActasBD.doc_descCastTramite).append(" TRAMITE, ");
		}
		else{
			strSql.append(W83aActasBD.tip_descEusk).append(" DESCRIPCION, ");
			strSql.append(W83aActasBD.doc_descEuskFase).append(" FASE, ");
			strSql.append(W83aActasBD.doc_descEuskTramite).append(" TRAMITE, ");
		}
		strSql.append(W83aActasBD.doc_numReg).append(", TO_CHAR(");
		strSql.append(W83aActasBD.doc_fechaReg).append(",?)F_REG_020,  ");
		strSql.append(W83aActasBD.doc_usuario);

		strSql.append(" FROM w83b.").append(W83aActasBD.actas_docView);
		
		strSql.append(" WHERE ").append(W83aActasBD.doc_territActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aActasBD.doc_anyoActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aActasBD.doc_numActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aActasBD.doc_versionActa).append(" = ?");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		params.add(param.getNumActaTerritorio());		
		params.add(param.getNumActaAno());
		params.add(param.getNumActa());
		params.add(param.getVersion());//la version
		
		List listaDocumentos = W83aDataBase.executeQuery(strSql.toString(),params,W83aDocBean.class,null, "actas");
		
		return listaDocumentos;

		
	
	}
	public W83aActasBean obtenerImpugnaciones(w83a.w83aBeans.W83aActasBean param)
	throws Exception {
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		
		strSql.append(W83aActasBD.territ);
		strSql.append("||'/'||");
		strSql.append(W83aActasBD.ano_impug);
		strSql.append("||'/'||");
		strSql.append(" DECODE(LENGTH(TO_CHAR(").append(W83aActasBD.imp_num).append(")),");
		strSql.append(" 1,'00000'||TO_CHAR(").append(W83aActasBD.imp_num).append("),");
		strSql.append(" 2,'00000'||TO_CHAR(").append(W83aActasBD.imp_num).append("),");
		strSql.append(" 3,'00000'||TO_CHAR(").append(W83aActasBD.imp_num).append("),");
		strSql.append(" 4,'00000'||TO_CHAR(").append(W83aActasBD.imp_num).append("),");
		strSql.append(" 5,'00000'||TO_CHAR(").append(W83aActasBD.imp_num).append("),");
		strSql.append(" TO_CHAR(").append(W83aActasBD.imp_num).append("))");
		
		strSql.append(" AS NUM_IMPUGNACION, TO_CHAR (");
		strSql.append(W83aActasBD.imp_fecha).append(",?) FIMPUGNACIONDATE, TO_CHAR(");
		strSql.append(W83aActasBD.imp_fechaLaudo).append(",?) FECHALAUDO, TO_CHAR ( ");
		strSql.append(W83aActasBD.imp_fechaEnvioJuzgado).append(",?) FENVIOJUZGADODATE, TO_CHAR ( ");
		strSql.append(W83aActasBD.imp_fechaSentencia).append(",?) FSENTENCIADATE, TO_CHAR ( ");
		strSql.append(W83aActasBD.imp_fechaBajaDesestimiento).append(",?) FECHADESES, ");
		if (param.getIdioma().equals(W83aClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83aActasBD.imp_tipoc).append(" AS ").append(W83aActasBD.imp_tipo).append(", ");
		}else{
			strSql.append(W83aActasBD.imp_tipoe).append(" AS ").append(W83aActasBD.imp_tipo).append(", ");
		}
		strSql.append(W83aActasBD.imp_dni).append(", ");
		strSql.append(W83aActasBD.imp_sindicatos).append(", upper(");
		strSql.append(W83aActasBD.imp_nombre).append(") AS NOMARBITRO, ");
		strSql.append(W83aActasBD.imp_numLaudo).append(",");
		strSql.append(W83aActasBD.territ).append(",");;
		strSql.append(W83aActasBD.ano_impug).append(", ");
		strSql.append(W83aActasBD.imp_resultadoLaudo).append(", ");
		strSql.append(W83aActasBD.imp_nombreImpugnante).append(", ");
		if (param.getIdioma().equals(W83aClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83aImpugnacionesBD.descResultadoLaudo).append(" as ").append(W83aImpugnacionesBD.descResultadoLaudo);		
		}else{
			strSql.append(W83aImpugnacionesBD.descEusResultadoLaudo).append(" as ").append(W83aImpugnacionesBD.descResultadoLaudo);		
		}
		strSql.append(" FROM w83b.").append(W83aActasBD.actas_impugView);
		strSql.append(", ").append(W83aImpugnacionesBD.vistaResultadoLaudo);
		strSql.append(" WHERE ((NUM_ACTA =?");
		strSql.append(" AND ANO_ACTA= ?");
		strSql.append(" AND TERRIT=?) OR (");
		//strSql.append(" RESULTADOLAUDO =?");
		strSql.append("  NUM_PREAVISO=?");//AND
		strSql.append(" AND ANO_PREAVISO=?");
		strSql.append(" AND TERRIT=?)) and ");
		strSql.append(W83aActasBD.imp_resultadoLaudo);
		strSql.append(" = ");
		strSql.append(W83aImpugnacionesBD.numResultadoLaudo);
		strSql.append("(+)");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		//params.add("1");
		params.add(param.getNumPreaviso());
		params.add(param.getAnyoPreaviso());
		params.add(param.getNumActaTerritorio());
		if(param.getIdColumna()!=null&&!param.getIdColumna().equals("")){
			String[] ordenacion=param.getIdColumna().split(",");
			
			strSql.append(" ORDER BY ");
			for(int i=0;i<ordenacion.length;i++)
			{
				if(i!=0)
				{
					strSql.append(", ");
				}
					strSql.append(ordenacion[i]).append(" ").append(param.getSort());	
			}
		}
		else{
			strSql.append(" ORDER BY ").append(W83aActasBD.imp_numCompleto);
		}
		List listaImpugnaciones = W83aDataBase.executeQuery(strSql.toString(),params,W83aImpugnacionesBean.class,null, "acta");
		param.setListaImpugnaciones(listaImpugnaciones);
		return param;

	}
	public List obtenerActasParciales(w83a.w83aBeans.W83aActasBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append("PAR.").append(W83aActasBD.par_numActa).append(" N_ACTA_016,");
		strSql.append("PAR.").append(W83aActasBD.par_numRegDef).append(" N_REGDEF_016, TO_CHAR (PAR.");
		strSql.append(W83aActasBD.par_fRegDef).append(",?) FREGDEF_016, TO_CHAR(PAR.");
		strSql.append(W83aActasBD.par_fEntrada).append(",?) F_ENTRA_016, TO_CHAR (PAR.");
		strSql.append(W83aActasBD.par_fEleccion).append(",?) F_ELECC_016, TO_CHAR ( PAR.");
		strSql.append(W83aActasBD.par_fComision).append(", ?) F_COMIS_016, TO_CHAR (PAR.");
		strSql.append(W83aActasBD.par_fBaja).append(", ?) F_BAJA_016, ");
		strSql.append("PAR.").append(W83aActasBD.par_numPreaviso).append(" N_PREAVISO_016,");
		strSql.append("PAR.").append(W83aActasBD.par_codConvenio).append(" C_CONV_016,");
		strSql.append("PAR.").append(W83aActasBD.par_codBaja).append(" CBAJA_016, ");
		strSql.append("PAR.").append(W83aActasBD.par_tElectores).append(" TOTELEC_016,");
		strSql.append("PAR.").append(W83aActasBD.par_tCandidatos).append(" TOTALCANDIDATOS,");
		if (param.getIdioma().equals(W83aClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append("PAR.").append(W83aActasBD.par_descConvenio).append(" DESC_CONVENIO ");
		}
		else{
			strSql.append("PAR.").append(W83aActasBD.par_deseConvenio).append(" DESC_CONVENIO ");
		}
		strSql.append(" FROM w83b.").append(W83aActasBD.actas_parcialesView);
		strSql.append(" PAR WHERE ").append(W83aActasBD.par_numActaTotal).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aActasBD.par_anyoActaTotal).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aActasBD.par_territorio).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aActasBD.par_vers).append(" = (select max(").append(W83aActasBD.par_vers);
		strSql.append(") from ").append(W83aActasBD.actas_parcialesView);
		strSql.append(" TEMP WHERE TEMP.").append(W83aActasBD.par_numActaSing).append(" = PAR.");
		strSql.append(W83aActasBD.par_numActaSing);
		strSql.append(" AND TEMP.").append(W83aActasBD.par_anyoActa).append(" = PAR.");
		strSql.append(W83aActasBD.par_anyoActa);
		strSql.append(" AND TEMP.").append(W83aActasBD.par_terActa).append(" = PAR.");
		strSql.append(W83aActasBD.par_terActa).append(")");

		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		params.add(param.getNumActa());		
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		if(param.getIdColumna()!=null&&!param.getIdColumna().equals("")){
			String[] ordenacion=param.getIdColumna().split(",");
			
			strSql.append(" ORDER BY ");
			for(int i=0;i<ordenacion.length;i++)
			{
				if(i!=0)
				{
					strSql.append(", ");
				}
					strSql.append(ordenacion[i]).append(" ").append(param.getSort());	
			}
		}
		List listaActas = W83aDataBase.executeQuery(strSql.toString(),params,W83aActasBean.class,null, "DETALLE");
		
		return listaActas;

		

	}
	public W83aActasBean obtenerIncidenciasActas(W83aActasBean param)throws Exception {
		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aActasBD.inc_territ).append("||'/'||");
		strSql.append(W83aActasBD.inc_anyo).append("||'/'||");
		strSql.append("DECODE (LENGTH (TO_CHAR (").append(W83aActasBD.inc_num).append(")),");
		strSql.append("1, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("2, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("3, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("4, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("5, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append(" TO_CHAR (").append(W83aActasBD.inc_num).append(")) ");
		
		strSql.append(" as ");
		strSql.append(W83aActasBD.inc_num).append(", to_number(");
		strSql.append(W83aActasBD.inc_territ).append("||");
		strSql.append(W83aActasBD.inc_anyo).append("||");
		strSql.append("DECODE (LENGTH (TO_CHAR (").append(W83aActasBD.inc_num).append(")),");
		strSql.append("1, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("2, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("3, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("4, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("5, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append(" TO_CHAR (").append(W83aActasBD.inc_num).append(")) ");
		
		strSql.append(") as ");
		strSql.append(W83aActasBD.inc_num).append("_int, ");
		strSql.append(W83aActasBD.inc_dni).append(",");
		strSql.append(W83aActasBD.inc_tipoIncidencia).append(", TO_CHAR (");
		strSql.append(W83aActasBD.inc_fechaEntrada).append (",?) F_ENTRADA_061,");
		strSql.append(W83aActasBD.inc_fechaEntrada).append(" FECHA,");
		if (param.getIdioma().equals(W83aClsConstantes.CONSTANTE_CASTELLANO))
		{
			strSql.append(W83aActasBD.inc_desc).append(" AS DESCRIPCION ");
		}
		else{
			strSql.append(W83aActasBD.inc_dese).append(" AS DESCRIPCION ");
		}
		strSql.append(" FROM ").append(W83aActasBD.incidencias_Synonym).append(",");
		strSql.append(W83aActasBD.incidencias_descripcion_Synonym);
		strSql.append(" WHERE ").append(W83aActasBD.inc_numActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aActasBD.inc_anyoActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aActasBD.inc_territ).append(" = ?");
		
		strSql.append(" AND ");
		strSql.append(W83aActasBD.inc_tipoIncidencia).append("=");
		strSql.append(W83aActasBD.inc_tipoIncidenciaDesc);
		strSql.append(" AND ");
		strSql.append(W83aActasBD.inc_anoActaParcial).append(" is null");		
//		strSql.append(" ORDER BY ").append(W83aActasBD.inc_num).append("_int asc");
		
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());	
		
		strSql.append(" UNION SELECT ");
		strSql.append(W83aActasBD.inc_territ).append("||'/'||");
		strSql.append(W83aActasBD.inc_anyo).append("||'/'||");
		strSql.append("DECODE (LENGTH (TO_CHAR (").append(W83aActasBD.inc_num).append(")),");
		strSql.append("1, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("2, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("3, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("4, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("5, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append(" TO_CHAR (").append(W83aActasBD.inc_num).append(")) ");
		
		strSql.append(" as ");
		strSql.append(W83aActasBD.inc_num).append(", to_number(");
		strSql.append(W83aActasBD.inc_territ).append("||");
		strSql.append(W83aActasBD.inc_anyo).append("||");
		strSql.append("DECODE (LENGTH (TO_CHAR (").append(W83aActasBD.inc_num).append(")),");
		strSql.append("1, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("2, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("3, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("4, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append("5, '00000'|| TO_CHAR (").append(W83aActasBD.inc_num).append("),");
		strSql.append(" TO_CHAR (").append(W83aActasBD.inc_num).append(")) ");
		
		strSql.append(") as ");
		strSql.append(W83aActasBD.inc_num).append("_int, ");
		strSql.append(W83aActasBD.inc_dni).append(",");
		strSql.append(W83aActasBD.inc_tipoIncidencia).append(", TO_CHAR (");
		strSql.append(W83aActasBD.inc_fechaEntrada).append (",?) F_ENTRADA_061,");
		strSql.append(W83aActasBD.inc_fechaEntrada).append(" FECHA,");
		if (param.getIdioma().equals(W83aClsConstantes.CONSTANTE_CASTELLANO))
		{
			strSql.append(W83aActasBD.inc_desc).append(" AS DESCRIPCION ");
		}
		else{
			strSql.append(W83aActasBD.inc_dese).append(" AS DESCRIPCION ");
		}
		strSql.append(" FROM ").append(W83aActasBD.incidencias_Synonym).append(",");
		strSql.append(W83aActasBD.incidencias_descripcion_Synonym);
		strSql.append(" WHERE ").append(W83aActasBD.inc_nActaParcial).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aActasBD.inc_anoActaParcial).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aActasBD.inc_territ).append(" = ?");
		
		strSql.append(" AND ");
		strSql.append(W83aActasBD.inc_tipoIncidencia).append("=");
		strSql.append(W83aActasBD.inc_tipoIncidenciaDesc);
		strSql.append(" ORDER BY ").append(W83aActasBD.inc_num).append("_int asc");
		
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());	
		
		//crear un nuevo bean
		List listaIncidencias = W83aDataBase.executeQuery(strSql.toString(),params,W83aIncidenciaActaBean.class,null, null);
		
		param.setListaIncidencias(listaIncidencias);
		return param;
	}

public java.util.HashMap buscarEscrutinio(w83a.w83aBeans.W83aActasBean param) throws Exception{
	StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
	List params = new ArrayList();
	strSql.append("SELECT ");
	strSql.append(W83aEscrutiniosBD.codSind).append(",");
	strSql.append(W83aEscrutiniosBD.codigoColegio).append(",");
	strSql.append(W83aEscrutiniosBD.delegadosHombres).append(",");
	strSql.append(W83aEscrutiniosBD.delegadosMujeres).append(",");
	strSql.append(W83aEscrutiniosBD.numVotos).append(",");
	if (param.getIdioma().equals(W83aClsConstantes.CONSTANTE_CASTELLANO)){
		strSql.append(W83aSindicatosBD.descSindicatoCast).append(" as DESCRIPCION");
	}
	else{
		strSql.append(W83aSindicatosBD.descSindicatoEusk).append(" as DESCRIPCION");
	}
	

	strSql.append(" FROM ").append(W83aEscrutiniosBD.escrutVista).append(" ESCR, ");
	strSql.append(W83aSindicatosBD.sindicatosVista).append(" SIND ");
	strSql.append(" WHERE ESCR.").append(W83aEscrutiniosBD.codSind).append(" = ");
	strSql.append(W83aSindicatosBD.codSindicato);
	strSql.append(" AND ESCR.").append(W83aEscrutiniosBD.acta).append(" = ? AND ");
	strSql.append(" ESCR.").append(W83aEscrutiniosBD.anyoActa).append(" = ? AND ");
	strSql.append(" ESCR.").append(W83aEscrutiniosBD.territorioActa).append(" = ? AND ");
	strSql.append(" ESCR.").append(W83aEscrutiniosBD.versionActa).append(" = ? AND ");
	strSql.append(" ESCR.").append(W83aEscrutiniosBD.codigoColegio).append(" = ?  ");
	params.add(param.getNumActa());
	params.add(param.getNumActaAno());
	params.add(param.getNumActaTerritorio());
	params.add(param.getVersion());
	if(param.getModo().equals("C1")){
		params.add(param.getColegios().getCod1());
	}
	else{
		params.add(param.getColegios().getCod2());
	}
	HashMap listaEscrutinios=W83aDataBase.executeQueryHashMap(strSql.toString(),params, W83aListaEscrutiniosBean.class, param.getUsuarioBean(), "DETALLE","sindicato");
	
	return listaEscrutinios;	
}
public java.util.HashMap buscarDiferencia(w83a.w83aBeans.W83aActasBean param) throws Exception{
	StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
	List params = new ArrayList();
	strSql.append("SELECT ").append(W83aDiferenciasBD.codSind).append(",");
	strSql.append(W83aDiferenciasBD.codigoColegio).append(",").append(W83aDiferenciasBD.delegadosHombres).append(",");
	strSql.append(W83aDiferenciasBD.delegadosMujeres).append(",");
	if(param.getIdioma().equals(W83aClsConstantes.CONSTANTE_CASTELLANO)){
		strSql.append(W83aSindicatosBD.descSindicatoCast).append(" AS DESCRIPCION");
	}
	else{
		strSql.append(W83aSindicatosBD.descSindicatoEusk).append(" AS DESCRIPCION");
	}
	strSql.append(" FROM ").append(W83aDiferenciasBD.difVista).append(" DIF, ");
	strSql.append(W83aSindicatosBD.sindicatosVista).append(" SIND ");
	strSql.append(" WHERE DIF.").append(W83aDiferenciasBD.codSind).append(" = ").append(W83aSindicatosBD.codSindicato);
	strSql.append(" AND DIF.").append(W83aDiferenciasBD.acta).append(" = ? AND ");
	strSql.append(" DIF.").append(W83aDiferenciasBD.anyoActa).append(" = ? AND ");
	strSql.append(" DIF.").append(W83aDiferenciasBD.territorioActa).append(" = ? AND ");
	strSql.append(" DIF.").append(W83aDiferenciasBD.versionActa).append(" = ? AND ");
	strSql.append(" DIF.").append(W83aDiferenciasBD.codigoColegio).append(" = ? ");
	params.add(param.getNumActa());
	params.add(param.getNumActaAno());
	params.add(param.getNumActaTerritorio());
	params.add(param.getVersion());
	if(param.getModo().equals("C1")){
		params.add(param.getColegios().getCod1());
	}
	else{
		params.add(param.getColegios().getCod2());
	}
	return W83aDataBase.executeQueryHashMap(strSql.toString(),params,W83aListaDiferenciasBean.class,param.getUsuarioBean(), "DETALLE","sindicato");
	
}
public java.util.HashMap buscarListaDelegados(w83a.w83aBeans.W83aActasBean param) throws Exception{
	StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
	//IDENTIFICAR USUARIO
	//W83aDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
	
	List params = new ArrayList();
	strSql.append("SELECT ");
	strSql.append(W83aDelegadosBD.codColegio).append(",");
	strSql.append(W83aDelegadosBD.dni).append(",");
	strSql.append(W83aDelegadosBD.nombre).append(",");
	strSql.append(W83aDelegadosBD.apellido1).append(",");
	strSql.append(W83aDelegadosBD.apellido2).append(",");
	strSql.append(W83aDelegadosBD.sexo).append(",TO_CHAR(");
	strSql.append(W83aDelegadosBD.fechaAlta).append(",?) F_ALTA_025 ,TO_CHAR(");
	strSql.append(W83aDelegadosBD.fechaBaja).append(",?) F_BAJA_025,");
	strSql.append("CASE WHEN ").append(W83aDelegadosBD.codColegio).append("=0 THEN '")
	.append(W83aClsConstantes.CONSTANTE_DESCRIP_TECNICOS).append("' ELSE '")
	.append(W83aClsConstantes.CONSTANTE_DESCRIP_ESPECIALISTAS).append("' END AS COLEGIO")
	.append(",");
	if (param.getIdioma().equals(W83aClsConstantes.CONSTANTE_CASTELLANO)){
		strSql.append(W83aSindicatosBD.descSindicatoCast).append(" AS SINDICATO,");
		strSql.append(W83aColegiosBD.descripcion).append(" AS DESCCOLEGIO,");
		strSql.append(W83aMotivosBajaDelegadoBD.descMotivoCast).append(" AS BAJA,");
	}
	else{
		strSql.append(W83aSindicatosBD.descSindicatoEusk).append(" AS SINDICATO,");
		strSql.append(W83aColegiosBD.descripcion_eu).append(" AS DESCCOLEGIO,");
		strSql.append(W83aMotivosBajaDelegadoBD.descMotivoEusk).append(" AS BAJA,");
	}
	strSql.append(W83aSindicatosBD.siglas).append(" AS SIGLAS,");
	strSql.append(W83aDelegadosBD.dniSustituto).append(",");
	strSql.append(W83aDelegadosBD.baja).append(",");
	strSql.append(W83aDelegadosBD.codSindicato);
	strSql.append(" FROM ").append(W83aDelegadosBD.delegadosVista).append(" DEL, ");
	strSql.append(W83aSindicatosBD.sindicatosVista).append(" SIND, ");
	strSql.append(W83aColegiosBD.colegiosTable).append(" COL, ");
	strSql.append(W83aMotivosBajaDelegadoBD.motivosBajaVista).append(" BAJA ");
	strSql.append(" WHERE DEL.").append(W83aDelegadosBD.codSindicato).append(" = SIND.");
	strSql.append(W83aSindicatosBD.codSindicato);
	strSql.append(" AND DEL.").append(W83aDelegadosBD.acta).append(" = ? AND ");
	strSql.append(" DEL.").append(W83aDelegadosBD.anyoActa).append(" = ? AND ");
	strSql.append(" DEL.").append(W83aDelegadosBD.territorioActa).append(" = ? AND ");
	strSql.append(" DEL.").append(W83aDelegadosBD.versionActa).append(" = ? AND ");
	strSql.append(" DEL.").append(W83aDelegadosBD.codColegio).append(" = ");
	strSql.append(" COL.").append(W83aColegiosBD.cod).append(" AND ");
	strSql.append(" DEL.").append(W83aDelegadosBD.baja).append(" = ");
	strSql.append(" BAJA.").append(W83aMotivosBajaDelegadoBD.codMotivo).append("(+)");
	params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	
	params.add(param.getNumActa());
	params.add(param.getNumActaAno());
	params.add(param.getNumActaTerritorio());
	params.add(param.getVersion());
	HashMap resultado = W83aDataBase.executeQueryHashMap(strSql.toString(),params,W83aListaDelegadosBean.class,param.getUsuarioBean(), "DETALLE","dni");
	//TERMINAR USUARIO
	//W83aDataBase.terminarUsuarioAuditor();
	
	return resultado;
	
}

public String obtenerTerritorio(String provincia) throws Exception{
	StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
//	String m="";
	String p="";
	List params = new ArrayList();
	
    strSql.append("SELECT ");
    strSql.append(W83aProvinciasBD.nomProvinc_Cast).append(" AS ").append(W83aProvinciasBD.descmunicipio);
    strSql.append(" FROM ");
    strSql.append(W83aProvinciasBD.provinciasTable);
    strSql.append(" WHERE ");
    strSql.append(W83aProvinciasBD.codProvinc).append("=?");
    
    if (provincia.length()==1){
    	p="0"+provincia;
    }
    else{
    	p=provincia;
    }
   
    params.add(p);
	
    List lista = W83aDataBase.executeSimpleQuerySinTrazas(strSql.toString(),params,null);
    
    if(lista.size()>0){	    
    	return lista.get(0).toString().toUpperCase();
    }else{
    	return "";	    	
    }
	
}

public String obtenerMunicipio(String provincia,String municipio) throws Exception{
	StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
	String m="";
	String p="";
	List params = new ArrayList();
	
    strSql.append("SELECT ");
    strSql.append(W83aMunicipioBD.dso).append(" AS ").append(W83aMunicipioBD.descmunicipio);
    strSql.append(" FROM ");
    strSql.append(W83aMunicipioBD.tablamunicipio);
    strSql.append(" WHERE ");
    strSql.append(W83aMunicipioBD.provinciaid).append("=?");
    strSql.append(" AND ");
    strSql.append(W83aMunicipioBD.id).append("=?");
    
    if (provincia.length()==1){
    	p="0"+provincia;
    }
    else{
    	p=provincia;
    }
    
    if (municipio.length()==1){
    	m="00"+municipio;
    }else if (municipio.length()==2){
    	m="0"+municipio;
    }
    else{
    	m=municipio;
    }
    
    params.add(p);
    params.add(m);
	
    List lista = W83aDataBase.executeSimpleQuerySinTrazas(strSql.toString(),params,null);
    
    if(lista.size()>0){	    
    	return lista.get(0).toString().toUpperCase();
    }else{
    	return "";	    	
    }
	
}
public W83aDocBean descargarDocumento(String param) throws Exception {
	
	StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
	List params = new ArrayList();
	
	strSql.append("SELECT ");
	strSql.append(W83aActasBD.doc_nombre).append(",");
	strSql.append(W83aActasBD.doc_longitud).append(",");
	strSql.append(W83aActasBD.doc_documento);
	strSql.append(" FROM ").append(W83aActasBD.actas_docsTable);
	//TODO cambiar por id_doc_037
	strSql.append(" WHERE ").append(W83aActasBD.doc_id).append(" = ?");
	
	params.add(param);		
	
	List listaDocumentos = W83aDataBase.executeQuery(strSql.toString(),params,W83aDocBean.class,null, "actas");
	
	if (listaDocumentos.size()>0)
		return (W83aDocBean)listaDocumentos.get(0);
	else
		throw new Exception("No existe ese documento");

	

}
}
